define('bitbucket-plugin-code-insights/internal/state/insight-state-utils', ['exports', 'lodash', 'redux', 'bitbucket/internal/util/store/reducers'], function (exports, _lodash, _redux, _reducers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.requestsReducer = exports.getPRSourceCommit = undefined;
    var getPRSourceCommit = exports.getPRSourceCommit = function getPRSourceCommit(pr) {
        return pr.fromRef.latestCommit;
    };

    var requestsReducer = exports.requestsReducer = function requestsReducer(load, success, failure) {
        return (0, _redux.combineReducers)({
            errors: (0, _reducers.errorsReducer)([], success, failure),
            loading: (0, _reducers.toggleReducer)({
                on: [load],
                off: [success, failure]
            })
        });
    };
});