define('bitbucket-plugin-code-insights/internal/state/annotations-by-report-state', ['exports', 'lodash', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', './insight-shared-state', './insight-state-utils'], function (exports, _lodash, _reselect, _navbuilder, _restActor, _reducers, _insightSharedState, _insightStateUtils) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.reducers = exports.selectors = exports.actors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var LOAD_ANNOTATIONS_FOR_REPORT = 'LOAD_ANNOTATIONS_FOR_REPORT';
    var LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS = 'LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS';
    var LOAD_ANNOTATIONS_FOR_REPORT_FAILURE = 'LOAD_ANNOTATIONS_FOR_REPORT_FAILURE';

    var actionCreators = exports.actionCreators = {
        loadAnnotationsForReport: function loadAnnotationsForReport(_ref) {
            var report = _ref.report,
                pullRequest = _ref.pullRequest;
            return {
                type: LOAD_ANNOTATIONS_FOR_REPORT,
                payload: {
                    report: report,
                    pullRequest: pullRequest
                },
                meta: {
                    successType: LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS,
                    failureType: LOAD_ANNOTATIONS_FOR_REPORT_FAILURE
                }
            };
        }
    };

    var actors = exports.actors = [(0, _restActor.restActorForType)(LOAD_ANNOTATIONS_FOR_REPORT, function (action) {
        return {
            url: _navbuilder2.default.rest('insights').pullRequest(action.payload.pullRequest).addPathComponents('annotations').withParams({
                key: action.payload.report.key
            }).build(),
            statusCode: {
                '*': false
            }
        };
    })];

    var selectors = exports.selectors = function selectors(_ref2) {
        var pullRequestSelector = _ref2.pullRequestSelector,
            reportKeySelector = _ref2.reportKeySelector;

        var _globalSelectors = (0, _insightSharedState.selectors)(pullRequestSelector),
            annotationsByReportStateSelector = _globalSelectors.annotationsByReportStateSelector,
            annotationRequestsByReportStateSelector = _globalSelectors.annotationRequestsByReportStateSelector,
            sourceCommitSelector = _globalSelectors.sourceCommitSelector;

        var annotationsLoadingForReportSelector = (0, _reselect.createSelector)(annotationRequestsByReportStateSelector, reportKeySelector, function (annotationRequestsByReport, reportKey) {
            return (0, _lodash.get)(annotationRequestsByReport, [reportKey, 'loading']);
        });

        var annotationsErrorsForReportSelector = (0, _reselect.createSelector)(annotationRequestsByReportStateSelector, reportKeySelector, function (annotationRequestsByReport, reportKey) {
            return (0, _lodash.get)(annotationRequestsByReport, [reportKey, 'errors']);
        });

        var annotationsForReportSelector = (0, _reselect.createSelector)(annotationsByReportStateSelector, sourceCommitSelector, reportKeySelector, function (annotationsByReportState, sourceCommit, reportKey) {
            return (0, _lodash.get)(annotationsByReportState, [sourceCommit, reportKey, 'values'], null);
        });

        var annotationsTruncatedForReportSelector = (0, _reselect.createSelector)(annotationsByReportStateSelector, sourceCommitSelector, reportKeySelector, function (annotationsByReportState, sourceCommit, reportKey) {
            return (0, _lodash.get)(annotationsByReportState, [sourceCommit, reportKey, 'truncated'], null);
        });

        return {
            annotationsForReportSelector: annotationsForReportSelector,
            annotationsLoadingForReportSelector: annotationsLoadingForReportSelector,
            annotationsErrorsForReportSelector: annotationsErrorsForReportSelector,
            annotationsTruncatedForReportSelector: annotationsTruncatedForReportSelector
        };
    };

    // In some cases we key our state tree by a PR's source commit
    // this is so that if the source commit changes, we pull in new data.
    // This is a SAFE action for reports, which only change with the source commit
    // This is an UNSAFE action for annotations, which _could_ be outdated by changes
    // on the target branch. However, for annotations in the modal, we accept this limitation
    // for two reasons:
    // - we don't have access to the merge commit (it's not on the PR and isn't returned with annotations)
    //   so we'd need extra requests to check against it.
    // - people aren't looking at the diff so they're unlikely to see the conflict anyway
    // For annotations on diffs, we have a merge commit to compare against and use it.
    var versionBySourceCommit = (0, _reducers.versionBy)(function (_ref3) {
        var type = _ref3.type,
            payload = _ref3.payload,
            meta = _ref3.meta;

        switch (type) {
            case LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS:
                return (0, _insightStateUtils.getPRSourceCommit)(payload.pullRequest);
        }
    }, 'commit');

    // key some state off of a report key (e.g. annotations by report)
    var keyByReport = (0, _reducers.keyBy)(function (_ref4) {
        var type = _ref4.type,
            payload = _ref4.payload,
            meta = _ref4.meta;

        switch (type) {
            case LOAD_ANNOTATIONS_FOR_REPORT:
                return payload.report.key;
            case LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS:
            case LOAD_ANNOTATIONS_FOR_REPORT_FAILURE:
                return meta.originalAction.payload.report.key;
        }
    });

    var addUniqueId = function addUniqueId(o) {
        return _extends({
            id: (0, _lodash.uniqueId)()
        }, o);
    };

    var reducers = exports.reducers = {
        requests: keyByReport((0, _insightStateUtils.requestsReducer)(LOAD_ANNOTATIONS_FOR_REPORT, LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS, LOAD_ANNOTATIONS_FOR_REPORT_FAILURE)),
        annotations: versionBySourceCommit(keyByReport((0, _reducers.reduceByType)(null, _defineProperty({}, LOAD_ANNOTATIONS_FOR_REPORT_SUCCESS, function (state, action) {
            return {
                truncated: action.payload.truncated,
                values: action.payload.annotations.map(addUniqueId)
            };
        }))))
    };
});