define('bitbucket-plugin-code-insights/internal/report-dialog/report-dialog', ['exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/bbui/aui-react/messages', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/widget/icons/icons', 'bitbucket/internal/widget/time', '../analytics', '../annotation-table/annotation-table', '../annotation-table/reporter-logo', '../annotations-summary/annotations-summary', '../list-and-detail/list-and-detail', '../report', '../report-custom-data/report-custom-data'], function (exports, _aui, _propTypes, _react, _dialog, _messages, _reactFunctional, _icons, _time, _analytics, _annotationTable, _reporterLogo, _annotationsSummary, _listAndDetail, _report, _reportCustomData) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.ReportDetail = undefined;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _time2 = _interopRequireDefault(_time);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _annotationTable2 = _interopRequireDefault(_annotationTable);

    var _reporterLogo2 = _interopRequireDefault(_reporterLogo);

    var _annotationsSummary2 = _interopRequireDefault(_annotationsSummary);

    var _listAndDetail2 = _interopRequireDefault(_listAndDetail);

    var _reportCustomData2 = _interopRequireDefault(_reportCustomData);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var analysisDateMappings = function analysisDateMappings(reporter) {
        return reporter ? {
            aMomentAgo: function aMomentAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.a.moment.ago', reporter);
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.one.minute.ago', reporter);
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.x.minutes.ago', reporter, param);
            },
            oneHourAgo: function oneHourAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.one.hour.ago', reporter);
            },
            xHoursAgo: function xHoursAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.x.hours.ago', reporter, param);
            },
            oneDayAgo: function oneDayAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.one.day.ago', reporter);
            },
            xDaysAgo: function xDaysAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.x.days.ago', reporter, param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.one.week.ago', reporter);
            },
            absolute: function absolute(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.reporter.absolute', reporter, param);
            }
        } : {
            aMomentAgo: function aMomentAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.a.moment.ago');
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.one.minute.ago');
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.x.minutes.ago', param);
            },
            oneHourAgo: function oneHourAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.one.hour.ago');
            },
            xHoursAgo: function xHoursAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.x.hours.ago', param);
            },
            oneDayAgo: function oneDayAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.one.day.ago');
            },
            xDaysAgo: function xDaysAgo(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.x.days.ago', param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.one.week.ago');
            },
            absolute: function absolute(param) {
                return _aui.I18n.getText('bitbucket.codeinsights.analysis.date.noreporter.absolute', param);
            }
        };
    };

    var CTAMenuItem = function CTAMenuItem() {
        return _react2.default.createElement(
            'div',
            { className: 'report-menu-item cta-menu-item' },
            _react2.default.createElement(_icons.AddIcon, { size: 'small' }),
            _react2.default.createElement(
                'span',
                { className: 'title' },
                _aui.I18n.getText('bitbucket.codeinsights.overview.list.cta.title')
            )
        );
    };

    var CTADetail = function CTADetail() {
        return _react2.default.createElement(
            'div',
            { className: 'report-detail cta-detail' },
            _react2.default.createElement('div', { className: 'code-insights-cta-image' }),
            _react2.default.createElement(
                'h1',
                null,
                _aui.I18n.getText('bitbucket.codeinsights.overview.detail.cta.title')
            ),
            _react2.default.createElement(
                'p',
                null,
                _aui.I18n.getText('bitbucket.codeinsights.overview.detail.cta.text')
            ),
            _react2.default.createElement(
                'a',
                {
                    className: 'aui-button aui-button-primary',
                    href: bitbucket_help_url('bitbucket.go.code.insights.learn.more')
                },
                _aui.I18n.getText('bitbucket.codeinsights.overview.detail.cta.link.title')
            )
        );
    };

    var ReportMenuItem = (0, _reactFunctional.pure)(function (_ref) {
        var report = _ref.item;
        var title = report.title,
            result = report.result;

        return _react2.default.createElement(
            'div',
            { className: 'report-menu-item' },
            _react2.default.createElement(_reporterLogo2.default, { report: report }),
            _react2.default.createElement(
                'span',
                { className: 'title' },
                title
            ),
            result ? result === _report.ResultEnum.PASS ? _react2.default.createElement(
                'span',
                { className: 'aui-lozenge aui-lozenge-subtle aui-lozenge-success' },
                _aui.I18n.getText('bitbucket.codeinsights.result.lozenge.pass')
            ) : _react2.default.createElement(
                'span',
                { className: 'aui-lozenge aui-lozenge-subtle aui-lozenge-error' },
                _aui.I18n.getText('bitbucket.codeinsights.result.lozenge.fail')
            ) : null
        );
    });

    var Messages = function Messages(_ref2) {
        var annotationsErrors = _ref2.annotationsErrors,
            truncated = _ref2.truncated;

        if (!truncated && !annotationsErrors) {
            return null;
        }

        return _react2.default.createElement(
            _react.Fragment,
            null,
            annotationsErrors && annotationsErrors.length ? _react2.default.createElement(
                _messages.WarningMessage,
                null,
                _aui.I18n.getText('bitbucket.rest.codeinsights.annotation.warning.could.not.retrieve.annotations')
            ) : null,
            truncated && _react2.default.createElement(
                _messages.WarningMessage,
                null,
                _aui.I18n.getText('bitbucket.rest.codeinsights.annotation.error.exceed.lines')
            )
        );
    };

    function reportLinkClicked(report) {
        (0, _analytics2.default)('stash.client.codeinsights.overview.report.reporter.link.clicked', {
            'report.result': report.result
        });
    }

    var ReportDetail = exports.ReportDetail = (0, _reactFunctional.pure)(function (_ref3) {
        var report = _ref3.item,
            annotations = _ref3.annotations,
            annotationsErrors = _ref3.annotationsErrors,
            pullRequest = _ref3.pullRequest,
            onAnnotationLinkClicked = _ref3.onAnnotationLinkClicked,
            truncated = _ref3.truncated;
        var title = report.title,
            details = report.details,
            link = report.link,
            createdDate = report.createdDate,
            reporter = report.reporter,
            data = report.data;

        return _react2.default.createElement(
            'div',
            { className: 'report-detail' },
            _react2.default.createElement(
                'h1',
                null,
                link ? _react2.default.createElement(
                    'a',
                    {
                        href: link,
                        onClick: function onClick() {
                            return reportLinkClicked(report);
                        },
                        target: '_blank',
                        rel: 'noopener noreferrer'
                    },
                    title
                ) : title
            ),
            _react2.default.createElement(_time2.default, {
                className: 'created-date',
                unixTime: createdDate,
                type: 'shortAge',
                customMapping: analysisDateMappings(reporter)
            }),
            details && _react2.default.createElement(
                'p',
                { className: 'report-detail-text' },
                details
            ),
            _react2.default.createElement(_reportCustomData2.default, { data: data }),
            _react2.default.createElement(_annotationsSummary2.default, { annotations: annotations }),
            _react2.default.createElement(Messages, { annotationsErrors: annotationsErrors, truncated: truncated }),
            _react2.default.createElement(_annotationTable2.default, {
                pullRequest: pullRequest,
                report: report,
                onFileClick: onAnnotationLinkClicked,
                annotations: annotations
            })
        );
    });

    var ReportDialog = function ReportDialog(_ref4) {
        var reports = _ref4.reports,
            pullRequest = _ref4.pullRequest,
            onClose = _ref4.onClose,
            onItemSelected = _ref4.onItemSelected,
            _onAnnotationLinkClicked = _ref4.onAnnotationLinkClicked,
            _ref4$Detail = _ref4.Detail,
            Detail = _ref4$Detail === undefined ? ReportDetail : _ref4$Detail;

        return _react2.default.createElement(
            _dialog2.default,
            {
                id: 'code-insights-reports',
                titleContent: _aui.I18n.getText('bitbucket.codeinsights.summary.reports'),
                showCloseButton: true,
                onClose: onClose,
                size: _dialog.DialogSize.XLARGE
            },
            _react2.default.createElement(_listAndDetail2.default, {
                items: reports.concat({ cta: true }),
                idKey: function idKey(_ref5) {
                    var cta = _ref5.cta,
                        key = _ref5.key;
                    return cta ? '___cta' : key;
                },
                menuItem: function menuItem(props) {
                    return props.item.cta ? _react2.default.createElement(CTAMenuItem, null) : _react2.default.createElement(ReportMenuItem, props);
                },
                detail: function detail(props) {
                    (0, _analytics2.default)('stash.client.codeinsights.overview.report.list.report.show', {
                        'report.count': reports.length,
                        'report.index': props.index,
                        'report.result': props.item.result
                    });
                    return props.item.cta ? _react2.default.createElement(CTADetail, null) : _react2.default.createElement(Detail, _extends({}, props, {
                        pullRequest: pullRequest,
                        onAnnotationLinkClicked: function onAnnotationLinkClicked(e, annotation) {
                            (0, _analytics2.default)('stash.client.codeinsights.overview.report.annotation.link.clicked', {
                                'annotation.outdated': annotation.outdated,
                                'annotation.severity': annotation.severity,
                                'annotation.type': annotation.type,
                                'report.result': props.item.result
                            });
                            _onAnnotationLinkClicked(e);
                        }
                    }));
                },
                onItemSelected: onItemSelected
            })
        );
    };

    ReportDialog.propTypes = {
        reports: _propTypes2.default.array.isRequired,
        onClose: _propTypes2.default.func.isRequired,
        onItemSelected: _propTypes2.default.func
    };

    exports.default = (0, _reactFunctional.pure)(ReportDialog);
});