/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RevertCommandParameters
extends AbstractCommandParameters {
    private final Branch branch;
    private final String commitId;
    private final ApplicationUser committer;
    private final Integer mergedCommitParentNumber;
    private final String targetBranch;

    private RevertCommandParameters(Builder builder) {
        this.branch = Objects.requireNonNull(builder.branch, "branch");
        this.committer = Objects.requireNonNull(builder.committer, "committer");
        this.commitId = Objects.requireNonNull(builder.commitId, "commitId");
        this.mergedCommitParentNumber = builder.mergedCommitParentNumber;
        this.targetBranch = builder.targetBranch;
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public ApplicationUser getCommitter() {
        return this.committer;
    }

    @Nonnull
    public Optional<Integer> getMergedCommitParentNumber() {
        return Optional.ofNullable(this.mergedCommitParentNumber);
    }

    @Nonnull
    public Optional<String> getTargetBranch() {
        return Optional.ofNullable(this.targetBranch);
    }

    public static class Builder {
        private Branch branch;
        private String commitId;
        private ApplicationUser committer;
        private Integer mergedCommitParentNumber;
        private String targetBranch;

        @Nonnull
        public Builder branch(@Nonnull Branch value) {
            this.branch = Objects.requireNonNull(value, "branch");
            return this;
        }

        @Nonnull
        public RevertCommandParameters build() {
            return new RevertCommandParameters(this);
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitId = Objects.requireNonNull(value, "commitId");
            return this;
        }

        @Nonnull
        public Builder committer(@Nonnull ApplicationUser value) {
            this.committer = Objects.requireNonNull(value, "committer");
            return this;
        }

        @Nonnull
        public Builder mergedCommitParentNumber(@Nullable Integer value) {
            this.mergedCommitParentNumber = value;
            return this;
        }

        @Nonnull
        public Builder targetBranch(@Nullable String value) {
            this.targetBranch = value;
            return this;
        }
    }
}

