/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.validation.annotation.FieldEquals;
import java.lang.reflect.Field;
import java.util.HashSet;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class FieldEqualsValidator
implements ConstraintValidator<FieldEquals, Object> {
    private String[] fields;
    private String message;
    private String reportingField;

    public void initialize(FieldEquals constraint) {
        this.fields = constraint.fields();
        this.reportingField = constraint.reportingField();
        this.message = constraint.message();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        boolean fieldMatches = this.fieldMatches(object, this.fields);
        if (!fieldMatches) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.message).addNode(this.reportingField).addConstraintViolation();
        }
        return fieldMatches;
    }

    private boolean fieldMatches(Object value, String[] fields) {
        HashSet<Object> values = new HashSet<Object>(fields.length);
        for (String fieldName : fields) {
            try {
                Field field = this.findField(value.getClass(), fieldName);
                if (field == null) {
                    throw new IllegalStateException("Couldn't find field: " + fieldName);
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                values.add(field.get(value));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Inaccessible field: " + fieldName);
            }
        }
        return values.size() == 1;
    }

    private Field findField(Class<?> clazz, String name) {
        while (!Object.class.equals(clazz) && clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

