/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractDiffStatsSummaryCommandParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffStatsSummaryCommandParameters
extends AbstractDiffStatsSummaryCommandParameters {
    private final Repository secondaryRepository;
    private final String sinceId;
    private final String untilId;

    private DiffStatsSummaryCommandParameters(Builder builder) {
        super(builder);
        this.secondaryRepository = builder.secondaryRepository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public static class Builder
    extends AbstractDiffStatsSummaryCommandParameters.AbstractBuilder<Builder> {
        private Repository secondaryRepository;
        private String sinceId;
        private String untilId;

        @Nonnull
        public DiffStatsSummaryCommandParameters build() {
            if (StringUtils.isBlank((CharSequence)this.untilId)) {
                throw new IllegalStateException("An \"until\" ID is required to generate diff stats summary");
            }
            return new DiffStatsSummaryCommandParameters(this);
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this.self();
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this.self();
        }

        @Nonnull
        public Builder untilId(@Nonnull String value) {
            this.untilId = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

