/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class TraversalRequest {
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Repository repository;

    private TraversalRequest(Set<String> excludes, Set<String> includes, Repository repository) {
        this.excludes = excludes;
        this.includes = includes;
        this.repository = repository;
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private Repository repository;

        @Nonnull
        public TraversalRequest build() {
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"A repository must be supplied");
            return new TraversalRequest((Set<String>)this.excludes.build(), (Set<String>)this.includes.build(), this.repository);
        }

        @Nonnull
        public Builder exclude(@Nonnull Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        @Nonnull
        public Builder exclude(@Nonnull String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nonnull Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nonnull String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this;
        }
    }
}

