/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.AbstractCommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitsRequest
extends AbstractCommitsRequest {
    private final String commitId;
    private final Instant since;

    private CommitsRequest(Builder builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.since = builder.since;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nullable
    public Instant getSince() {
        return this.since;
    }

    public static class Builder
    extends AbstractCommitsRequest.AbstractCommitsRequestBuilder<Builder> {
        private final String commitId;
        private Instant since;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            super(repository);
            this.commitId = Builder.requireNonBlank(commitId, "commitId");
        }

        @Nonnull
        public Builder since(@Nullable Instant value) {
            this.since = value;
            return this;
        }

        @Nonnull
        public CommitsRequest build() {
            return new CommitsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

