/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractRepositoryRefsRequest {
    private final boolean boostMatches;
    private final String filterText;
    private final RefOrder order;
    private final Repository repository;

    protected AbstractRepositoryRefsRequest(AbstractBuilder<?, ?> builder) {
        this.boostMatches = builder.boostMatches;
        this.filterText = builder.filterText;
        this.order = builder.order;
        this.repository = builder.repository;
    }

    @Nullable
    public String getFilterText() {
        return this.filterText;
    }

    public boolean isBoostMatches() {
        return this.boostMatches;
    }

    @Nullable
    public RefOrder getOrder() {
        return this.order;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractRepositoryRefsRequest>
    extends BuilderSupport {
        private final Repository repository;
        private boolean boostMatches;
        private String filterText;
        private RefOrder order;

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public B boostMatches(boolean value) {
            this.boostMatches = value;
            return this.self();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B filterText(@Nullable String value) {
            this.filterText = value;
            return this.self();
        }

        @Nonnull
        public B order(@Nullable RefOrder value) {
            this.order = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

