/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class AbstractPullRequestMergeConfigRequest {
    private final Project project;
    private final Repository repository;
    private final String scmId;

    protected AbstractPullRequestMergeConfigRequest(AbstractBuilder<?, ?> builder) {
        this.project = builder.project;
        this.repository = builder.repository;
        this.scmId = builder.scmId;
    }

    @Nonnull
    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    @Nonnull
    public Optional<Repository> getRepository() {
        return Optional.ofNullable(this.repository);
    }

    @Nonnull
    public Optional<String> getScmId() {
        return Optional.ofNullable(this.scmId);
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractPullRequestMergeConfigRequest>
    extends BuilderSupport {
        private final Project project;
        private final Repository repository;
        private final String scmId;

        protected AbstractBuilder(@Nonnull Project project, @Nonnull String scmId) {
            this.project = Objects.requireNonNull(project, "project");
            this.scmId = AbstractBuilder.requireNonBlank(scmId, "scmId");
            this.repository = null;
        }

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.project = null;
            this.scmId = null;
        }

        protected AbstractBuilder(@Nonnull String scmId) {
            this.scmId = AbstractBuilder.requireNonBlank(scmId, "scmId");
            this.project = null;
            this.repository = null;
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        protected abstract B self();
    }
}

