/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TransactionAware
public abstract class PermissionEvent
extends ApplicationEvent {
    private final Permission permission;
    private final String affectedGroup;
    private final ApplicationUser affectedUser;

    protected PermissionEvent(Object source, Permission permission, String affectedGroup, ApplicationUser affectedUser) {
        super(source);
        Preconditions.checkArgument((boolean)Objects.requireNonNull(permission, "permission").isGrantable(), (Object)"Permission must be grantable");
        this.permission = permission;
        this.affectedGroup = affectedGroup;
        this.affectedUser = affectedUser;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    @Nullable
    public String getAffectedGroup() {
        return this.affectedGroup;
    }

    @Nullable
    public ApplicationUser getAffectedUser() {
        return this.affectedUser;
    }
}

