/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.property.SimplePropertySupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ChangeContext
extends SimplePropertySupport {
    private final String fromHash;
    private final int maxChanges;
    private final String toHash;

    private ChangeContext(Builder builder) {
        super(builder);
        this.fromHash = builder.fromHash;
        this.maxChanges = builder.maxChanges;
        this.toHash = builder.toHash;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public static class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private final String fromHash;
        private final String toHash;
        private int maxChanges;

        public Builder(@Nullable String fromHash, @Nonnull String toHash) {
            this.fromHash = StringUtils.trimToNull((String)fromHash);
            this.toHash = Builder.checkNotBlank(toHash, "toHash");
        }

        public Builder(@Nonnull ChangeContext context) {
            super(context);
            this.fromHash = context.fromHash;
            this.toHash = context.toHash;
            this.maxChanges = context.maxChanges;
        }

        @Nonnull
        public ChangeContext build() {
            return new ChangeContext(this);
        }

        @Nonnull
        public Builder maxChanges(int value) {
            this.maxChanges = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

