/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PullRequestMergeRequest
extends AbstractPullRequestRequest {
    private final boolean autoSubject;
    private final String message;
    private final String strategyId;
    private final int version;

    protected PullRequestMergeRequest(Builder builder) {
        super(builder);
        this.autoSubject = builder.autoSubject;
        this.message = builder.message;
        this.strategyId = builder.strategyId;
        this.version = builder.version;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isAutoSubject() {
        return this.autoSubject || StringUtils.isBlank((CharSequence)this.message);
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final int version;
        private boolean autoSubject;
        private String message;
        private String strategyId;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
            this.version = pullRequest.getVersion();
            this.autoSubject = true;
        }

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);
            this.version = version;
            this.autoSubject = true;
        }

        @Nonnull
        public Builder autoSubject(boolean value) {
            this.autoSubject = value;
            return this.self();
        }

        @Nonnull
        public PullRequestMergeRequest build() {
            return new PullRequestMergeRequest(this);
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

