/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.permission;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.permission.PermissionI18n;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Permission {
    USER_ADMIN(11, 200, (Set)ImmutableSet.of(Integer.class, ApplicationUser.class), I18nArgs.EMPTY, new Permission[0]){

        @Override
        public boolean isGrantable() {
            return false;
        }
    }
    ,
    PROJECT_VIEW(10, 500, (Set)ImmutableSet.of(Integer.class, Project.class), I18nArgs.EMPTY, new Permission[0]){

        @Override
        public boolean isGrantable() {
            return false;
        }
    }
    ,
    REPO_READ(0, 1000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Repository.class), I18nArgs.EMPTY, PROJECT_VIEW),
    REPO_WRITE(1, 3000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Repository.class), I18nArgs.EMPTY, REPO_READ),
    REPO_ADMIN(8, 5000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Repository.class), I18nArgs.EMPTY, REPO_WRITE),
    PROJECT_READ(2, 2000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Project.class), I18nArgs.EMPTY, REPO_READ),
    PROJECT_WRITE(3, 4000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Project.class), I18nArgs.EMPTY, PROJECT_READ, REPO_WRITE),
    REPO_CREATE(12, 5500, (Set<Class<?>>)ImmutableSet.of(Integer.class, Project.class), I18nArgs.EMPTY, PROJECT_WRITE),
    PROJECT_ADMIN(4, 6000, (Set<Class<?>>)ImmutableSet.of(Integer.class, Project.class), I18nArgs.EMPTY, REPO_CREATE, REPO_ADMIN),
    LICENSED_USER(9, 0, I18nArgs.PRODUCT, new Permission[0]),
    PROJECT_CREATE(5, 7000, I18nArgs.EMPTY, LICENSED_USER),
    ADMIN(6, 9000, I18nArgs.PRODUCT, new Permission[]{PROJECT_CREATE, PROJECT_ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    }
    ,
    SYS_ADMIN(7, 10000, I18nArgs.PRODUCT, new Permission[]{ADMIN, USER_ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    };

    private static Map<Integer, Permission> idToPermissionMap;
    private static Map<Integer, Permission> weightToPermissionMap;
    private final int id;
    private final PermissionI18n i18n;
    private final Set<Permission> inheritedPermissions;
    private final Set<Class<?>> resourceTypes;
    private final int weight;
    private Set<Permission> implyingPermissions;
    private Set<Permission> inheritingPermissions;

    private Permission(int id, int weight, Set<Class<?>> resourceTypes, Object[] i18nArguments, Permission ... inherited) {
        this.id = id;
        this.i18n = new PermissionI18n(this, i18nArguments);
        this.resourceTypes = resourceTypes;
        this.weight = weight;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Permission p : inherited) {
            this.appendInheritedPermissions((ImmutableSet.Builder<Permission>)builder, p);
        }
        this.inheritedPermissions = builder.build();
    }

    private Permission(int id, int weight, Object[] i18nArguments, Permission ... inherited) {
        this(id, weight, Collections.emptySet(), i18nArguments, inherited);
    }

    @Nonnull
    public static Permission fromId(int id) {
        Permission permission;
        if (idToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission2 : Permission.values()) {
                builder.put((Object)permission2.getId(), (Object)permission2);
            }
            idToPermissionMap = builder.build();
        }
        if ((permission = idToPermissionMap.get(id)) == null) {
            throw new IllegalArgumentException("No Permission is associated with ID [" + id + "]");
        }
        return permission;
    }

    @Nullable
    public static Permission fromWeight(int weight) {
        if (weightToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission : Permission.values()) {
                builder.put((Object)permission.getWeight(), (Object)permission);
            }
            weightToPermissionMap = builder.build();
        }
        return weightToPermissionMap.get(weight);
    }

    @Nonnull
    public static Set<Permission> getGlobalPermissions() {
        return Sets.filter(EnumSet.allOf(Permission.class), Permission::isGlobal);
    }

    @Nonnull
    public static Set<Permission> getPermissionsOn(Class<?> resourceClass) {
        return Sets.filter(EnumSet.allOf(Permission.class), permission -> permission.isResource(resourceClass));
    }

    @Nullable
    public static Permission max(Permission p1, Permission p2) {
        if (p1 == null) {
            return p2;
        }
        return p2 == null || p1.getWeight() > p2.getWeight() ? p1 : p2;
    }

    @Nonnull
    public PermissionI18n getI18n() {
        return this.i18n;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public Set<Permission> getImplyingPermissions() {
        if (this.implyingPermissions == null) {
            EnumSet<Permission> inheriting = EnumSet.noneOf(Permission.class);
            inheriting.addAll(this.getInheritingPermissions());
            inheriting.remove((Object)this);
            this.implyingPermissions = Collections.unmodifiableSet(inheriting);
        }
        return this.implyingPermissions;
    }

    @Nonnull
    public Set<Permission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    @Nonnull
    public Set<Permission> getInheritingPermissions() {
        if (this.inheritingPermissions == null) {
            EnumSet<Permission> perms = EnumSet.of(this);
            for (Permission p : Permission.values()) {
                if (!p.getInheritedPermissions().contains((Object)this)) continue;
                perms.add(p);
            }
            this.inheritingPermissions = Collections.unmodifiableSet(perms);
        }
        return this.inheritingPermissions;
    }

    @Nonnull
    public Set<Class<?>> getResourceTypes() {
        return this.resourceTypes;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isGlobal() {
        return this.resourceTypes.isEmpty();
    }

    public boolean isGrantable() {
        return true;
    }

    public boolean isGrantableToAll() {
        return this.isGrantable();
    }

    public boolean isResource() {
        return !this.isGlobal();
    }

    public boolean isResource(Class<?> resourceClass) {
        return !this.isGlobal() && Iterables.any(this.resourceTypes, c -> c.isAssignableFrom(resourceClass));
    }

    private void appendInheritedPermissions(ImmutableSet.Builder<Permission> builder, Permission p) {
        builder.add((Object)p);
        for (Permission perm : p.getInheritedPermissions()) {
            this.appendInheritedPermissions(builder, perm);
        }
    }

    private static class I18nArgs {
        static final Object[] EMPTY = new Object[0];
        static final Object[] PRODUCT = new Object[]{Product.NAME};

        private I18nArgs() {
        }
    }
}

