package com.atlassian.bitbucket.watcher;

import javax.annotation.Nonnull;

public class UnwatchRequest extends AbstractWatcherRequest {

    private UnwatchRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, UnwatchRequest> {

        public Builder(@Nonnull Watchable watchable) {
            super(watchable);
        }

        @Nonnull
        @Override
        public UnwatchRequest build() {
            return new UnwatchRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
