package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.HttpURLValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * Validate that the string is a valid https or https URL.
 *
 * <p>This is used because @URL accepts other protocols such as ftp</p>
 * <p>URLs with query params or user info will validate false</p>
 *
 * @see java.net.URL
 * @see org.hibernate.validator.constraints.URL
 */
@Documented
@Constraint(validatedBy = HttpURLValidator.class)
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface HttpURL {

    String message() default "{com.atlassian.bitbucket.validation.httpurl.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
