package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Exception to represent possible validation errors.
 * <p>
 * This is thrown by {@link RepositoryHookService} when saving settings.
 */
public class FormValidationException extends ServiceException {

    private final FormErrors formErrors;

    public FormValidationException(@Nonnull KeyedMessage message, @Nonnull FormErrors formErrors) {
        super(message);
        this.formErrors = requireNonNull(formErrors, "formErrors");
    }

    @Nonnull
    public FormErrors getErrors() {
        return formErrors;
    }
}
