package com.atlassian.bitbucket.user;

/**
 * The type of {@link ApplicationUser user}
 */
public enum UserType {

    /**
     * 'Normal' users are backed by a user from a Crowd directory and are capable of authenticating
     * via the UI or REST provided they are licensed to do so.
     */
    NORMAL,
    /**
     * 'Service' users are not backed by a user from a Crowd directory and are not able to authenticate via
     * the UI or REST. Service users can be used to programmatically perform tasks which require an associated
     * user and do not count towards the licensed user count.
     */
    SERVICE
}
