package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * Implements the visitor pattern for {@link ApplicationUser users}.
 * <p>
 * Note: Implementors are <i>strongly</i> encouraged to extend from {@link AbstractApplicationUserVisitor} or
 * {@link AbstractVoidApplicationUserVisitor}. This interface <i>may</i> change over time, as more
 * {@link UserType user types} are added, and any class implementing it directly will be broken
 * by such changes. Extending from one of the abstract classes will help prevent such breakages.
 */
public interface ApplicationUserVisitor<T> {

    T visit(@Nonnull DetailedUser user);

    T visit(@Nonnull ServiceUser user);

    T visit(@Nonnull ApplicationUser user);
}
