package com.atlassian.bitbucket.timezone;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.ZoneId;

/**
 * Provides access to a user's time zone.
 *
 * @since 4.6
 */
public interface UserTimeZoneSupplier {

    /**
     * @return the time zone for the current user. Always returns a time zone. Will fall back to a default time zone
     * if necessary.
     */
    @Nonnull
    ZoneId getTimeZone();

    /**
     * @param user the user for which to find the time zone. Can be {@code null} for the anonymous user.
     * @return the time zone for the passed user. Always returns a time zone. Will fall back to a default time zone
     * if necessary.
     */
    @Nonnull
    ZoneId getTimeZone(@Nullable ApplicationUser user);
}
