package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.ScmExtendedCommandFactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Optional;

import static java.util.Optional.empty;
import static java.util.Optional.of;

/**
 * Built-in types of SCM objects that can be signed or for which signed contents can be
 * {@link ScmExtendedCommandFactory#signedObjects retrieved}.
 *
 * @since 5.1
 */
public enum StandardSignableObjectType implements SignableObjectType {

    COMMIT("commit"),
    TAG("tag");

    private final String id;

    StandardSignableObjectType(String id) {
        this.id = id;
    }

    @Nonnull
    public static Optional<StandardSignableObjectType> fromId(@Nullable String id) {
        for (StandardSignableObjectType objectType : values()) {
            if (objectType.id.equals(id)) {
                return of(objectType);
            }
        }

        return empty();
    }

    @Nonnull
    @Override
    public String getId() {
        return id;
    }
}
