package com.atlassian.bitbucket.scm.mirror;

/**
 * The type of synchronization performed on a mirrored repository
 *
 * @since 6.7
 */
public enum RepositorySynchronizationType {

    /**
     * Refs to be updated are computed by the orchestrator and relevant {@code update-ref} instructions
     * are passed to each member of the mirror farm. Each member then performs the instructions that were passed to it.
     */
    INCREMENTAL,
    /**
     * All refs on the remote are fetched by the orchestrator and passed to each member of the mirror farm.
     * Each member then updates its local refs to match the refs that were passed to it.
     */
    SNAPSHOT;

    public String toString() {
        return name().toLowerCase();
    }

}