package com.atlassian.bitbucket.scm.bulk;

/**
 * Describes how a file has changed in a bulk content command.
 *
 * @since 4.2
 */
public enum BulkChangeType {

    /**
     * File was added. In case the parameters for the bulk content command didn't specify a "since" commit ID, all files
     * will have this status.
     */
    ADD,

    /**
     * File was deleted compared to the "since" commit ID.
     */
    DELETE,

    /**
     * File was modified compared to the "since" commit ID.
     */
    MODIFY
}
