package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown by the {@link ScmService} to indicate that a plugin is installed for the requested SCM, but that the plugin
 * is not in a usable state.
 * <p>
 * For example, an SCM plugin which relies on the presence of an SCM-specific binary such as {@code git} or {@code hg}
 * may be installed but unavailable if that binary could not be found.
 *
 * @see UnsupportedScmException
 */
public class UnavailableScmException extends ScmException {

    public UnavailableScmException(@Nonnull KeyedMessage message, @Nonnull String scmId) {
        super(message, scmId);
    }
}
