package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessFailedException extends CommandFailedException {

    private final int exitCode;

    public ProcessFailedException(@Nonnull KeyedMessage message, int exitCode) {
        this(message, exitCode, null);
    }

    public ProcessFailedException(@Nonnull KeyedMessage message, int exitCode, @Nullable Throwable cause) {
        super(message, cause);

        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return exitCode;
    }
}
