package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static org.apache.commons.lang3.StringUtils.trimToNull;

/**
 * Parameters describing how a new repository should be created by the SCM.
 *
 * @since 7.5
 */
public class CreateCommandParameters extends AbstractCommandParameters {

    private final String defaultBranch;

    private CreateCommandParameters(Builder builder) {
        defaultBranch = builder.defaultBranch;
    }

    /**
     * Retrieves the default branch that should be set when the repository is created. If no default is specified,
     * the SCM will use its own. What that default is is not documented here because it is SCM-specific, and may
     * change between SCM releases.
     *
     * @return the default branch to set, or {@code null} to use the SCM's default branch
     */
    @Nullable
    public String getDefaultBranch() {
        return defaultBranch;
    }

    public static class Builder {

        private String defaultBranch;

        public Builder() {
        }

        @Nonnull
        public CreateCommandParameters build() {
            return new CreateCommandParameters(this);
        }

        @Nonnull
        public Builder defaultBranch(@Nullable String value) {
            defaultBranch = trimToNull(value);

            return this;
        }
    }
}
