package com.atlassian.bitbucket.scm;

/**
 * Enumerates the possible results of running a {@link Command command}.
 */
public enum CommandResult {

    /**
     * The command was canceled, either by the requester or because it timed out. The process of canceling the
     * command may have <i>also</i> caused other failures. If so, the system is ignoring them.
     */
    CANCELED,
    /**
     * The command failed. This may mean it was never started due to environment or resource problems, or that
     * it started and encountered an error during execution.
     */
    FAILED,
    /**
     * The command succeeded.
     */
    SUCCEEDED
}
