package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Basic implementation of {@link RepositoryRef}
 *
 * @since 5.0
 */
public class SimpleRepositoryRef extends SimpleMinimalRepositoryRef implements RepositoryRef {

    private final String latestCommit;

    private SimpleRepositoryRef(@Nonnull Builder builder) {
        super(builder);

        latestCommit = requireNonNull(builder.latestCommit, "latestCommit");
    }

    @Nonnull
    @Override
    public String getLatestCommit() {
        return latestCommit;
    }

    public static class Builder extends AbstractBuilder<Builder, SimpleRepositoryRef> {

        private String latestCommit;

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull Repository repository, @Nonnull Ref ref) {
            super(repository, ref);

            latestCommit = ref.getLatestCommit();
        }

        public Builder(@Nonnull SimpleRepositoryRef ref) {
            super(ref);

            latestCommit = ref.getLatestCommit();
        }

        @Nonnull
        @Override
        public SimpleRepositoryRef build() {
            return new SimpleRepositoryRef(this);
        }

        @Nonnull
        public Builder latestCommit(@Nonnull String value) {
            latestCommit = requireNonNull(value, "latestCommit");
            return self();
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
