package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Exception that is thrown when a repository is retrieved using an old slug, project key or namespace value after
 * any of these three fields have been updated (e.g. repository was renamed, moved to a different project or the
 * project key was changed).
 *
 * @since 5.0
 */
public class RepositoryMovedException extends EntityMovedException {

    private static final long serialVersionUID = 1L;

    private final String oldProjectKey;
    private final String oldSlug;
    private final Repository repository;

    /**
     * @since 7.18
     */
    public RepositoryMovedException(@Nonnull Repository repository, @Nonnull String projectKey, @Nonnull String slug, @Nonnull KeyedMessage message) {
        super(message);

        this.oldProjectKey = projectKey;
        this.oldSlug = slug;
        this.repository = repository;
    }

    @Nonnull
    public String getOldProjectKey() {
        return oldProjectKey;
    }

    @Nonnull
    public String getOldSlug() {
        return oldSlug;
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
