package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates no branch exists with the specified name.
 */
public class NoSuchBranchException extends NoSuchEntityException {

    private final String branchId;

    public NoSuchBranchException(KeyedMessage keyedMessage, String branchId) {
        super(keyedMessage);
        this.branchId = branchId;
    }

    /**
     * Retrieves the missing branch ID.
     *
     * @return the branch ID
     */
    public String getBranchId() {
        return branchId;
    }
}
