package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates the operation could not be completed because a ref already exists for the supplied name.
 */
public class DuplicateRefException extends IntegrityException {

    private final String refName;

    public DuplicateRefException(KeyedMessage message, String refName) {
        super(message);
        this.refName = requireNonNull(refName, "refName must be non-null");
    }

    @Nonnull
    public String getRefName() {
        return refName;
    }
}
