package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * @since 4.6
 */
public class BranchSummary extends AbstractSummary {

    private BranchSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, BranchSummary> {

        /**
         * Creates and initializes a new builder using details from the provided {@link AbstractSummary summary}.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public BranchSummary build() {
            return new BranchSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
