package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Describes a request to {@link PullRequestService#discardReview(PullRequestDiscardReviewRequest) discard a review} on
 * a {@link PullRequest pull request}.
 *
 * @since 7.7
 */
public class PullRequestDiscardReviewRequest extends AbstractPullRequestRequest {

    private PullRequestDiscardReviewRequest(@Nonnull Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder(@Nonnull PullRequest pullRequest) {
            super(requireNonNull(pullRequest, "pullRequest"));
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestDiscardReviewRequest build() {
            return new PullRequestDiscardReviewRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
