package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.content.Diff;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * A {@link PullRequestActivity} representing a {@link CommentAction comment action} made on the contents of the
 * pull request.
 *
 * @see PullRequestActivityType#COMMENT
 */
public interface PullRequestCommentActivity extends PullRequestActivity {

    /**
     * @return the comment associated with this activity.
     */
    @Nonnull
    Comment getComment();

    /**
     * @return the comment action on the {@link #getComment() comment}.
     */
    @Nonnull
    CommentAction getCommentAction();

    /**
     * @return the diff of the contents that the comment is anchored to, or {@code null} if this is a general comment
     * or a comment not associated with contents changed as part of this pull request (e.g. a file comment).
     * @since 5.0
     */
    @Nonnull
    Optional<Diff> getDiff();
}
