package com.atlassian.bitbucket.pull;

/**
 * Specifies the scope of the changes for a pull request.
 *
 * @see PullRequestChangesRequest#getChangeScope()
 * @since 4.10
 */
public enum PullRequestChangeScope {

    /**
     * No limit is placed on the scope of the changes for the pull request.
     */
    ALL,

    /**
     * Limits the scope of the changes for the pull request to one or more commits between
     * {@link PullRequestChangesRequest#getSinceId()} and {@link PullRequestChangesRequest#getUntilId()}.
     *
     * If either {@link PullRequestChangesRequest#getSinceId()} or {@link PullRequestChangesRequest#getUntilId()} are
     * not included in the {@link PullRequestChangesRequest request}, the scope defaults to {@link #ALL ALL} changes.
     *
     * @since 5.0
     */
    RANGE,

    /**
     * Limits the scope of the changes for the pull request to the changes which are unreviewed for the current user.
     * The unreviewed changes are considered to be the changes between the {@code lastReviewedCommit} of the current
     * user and the tip of the source branch.
     *
     * If there are no unreviewed changes, the scope defaults to {@link #ALL ALL} changes.
     *
     * @see PullRequestParticipant#getLastReviewedCommit()
     */
    UNREVIEWED
}
