package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/**
 * Indicates one or more reviewers could not be added to a new or existing pull request because the users either
 * don't exist, don't have permission to view the pull request.
 */
public class InvalidPullRequestReviewersException extends InvalidPullRequestParticipantsException {

    private static final long serialVersionUID = 1L;

    public InvalidPullRequestReviewersException(@Nonnull KeyedMessage message) {
        this(message, Collections.emptyMap(), Collections.emptySet());
    }

    public InvalidPullRequestReviewersException(@Nonnull KeyedMessage message,
                                                @Nonnull Map<String, KeyedMessage> reviewerErrorsByName,
                                                @Nonnull Set<ApplicationUser> validReviewers) {

        super(message, PullRequestRole.REVIEWER, reviewerErrorsByName, validReviewers);
    }

    @Nonnull
    public Map<String, KeyedMessage> getReviewerErrors() {
        return getErrorsByParticipantName();
    }

    @Nonnull
    public Set<ApplicationUser> getValidReviewers() {
        return getValidParticipants();
    }
}
