package com.atlassian.bitbucket.project;

import javax.annotation.Nonnull;

/**
 * @see ProjectService#update(ProjectUpdateRequest)
 */
public class ProjectUpdateRequest extends AbstractProjectRequest {

    private final int id;

    private ProjectUpdateRequest(Builder builder) {
        super(builder);

        id = builder.id;
    }

    /**
     * @return the id of the projects to be updated
     */
    public int getId() {
        return id;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private final int id;

        public Builder(@Nonnull Project project) {
            super(project);

            id = project.getId();
        }

        public Builder(int id) {
            this.id = id;
        }

        @Nonnull
        public ProjectUpdateRequest build() {
            return new ProjectUpdateRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
