package com.atlassian.bitbucket.migration.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when migrating repositories from Bitbucket DC to Mesh has completed executing.
 * <p>
 * To determine whether the migration has finished successfully, the {@link #getFinalState() state} should be inspected.
 *
 * @since 8.0
 */
@AsynchronousPreferred
@EventName("stash.migration.mesh.finished")
public class MeshMigrationFinishedEvent extends AbstractInstanceMigrationEvent {

    private final long errorCount;
    private final long infoCount;
    private final long warningCount;

    public MeshMigrationFinishedEvent(@Nonnull Object source, @Nonnull Job job, long errorCount,
                                      long infoCount, long warningCount) {
        super(source, job);
        this.errorCount = errorCount;
        this.infoCount = infoCount;
        this.warningCount = warningCount;
    }

    /**
     * @return count of migration error messages
     */
    public long getErrorCount() {
        return errorCount;
    }

    /**
     * @return The {@link JobState#getId()} that the migration job was in when it completed
     */
    public int getFinalState() {
        return job.getState().getId();
    }

    /**
     * @return count of migration info messages
     */
    public long getInfoCount() {
        return infoCount;
    }

    /**
     * @return count of migration info messages
     */
    public long getWarningCount() {
        return warningCount;
    }
}
