package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Indicates there was an attempt to send a mail message that exceeds the configured size limit.
 * Regarding logging instances of this exception, see {@link MailException}.
 */
public class MailSizeExceededException extends MailException {

    private final int maxSize;
    private final int size;

    /**
     * Constructs a new {@code MailSizeExceededException}.
     *
     * @param message the error message
     * @param size    the mail message's size
     * @param maxSize the configured size limit
     * @since 6.0
     */
    public MailSizeExceededException(@Nonnull KeyedMessage message, int size, int maxSize) {
        super(message);

        this.maxSize = maxSize;
        this.size = size;
    }

    /**
     * @return the configured maximum size for a single mail message
     * @since 6.0
     */
    public int getMaxSize() {
        return maxSize;
    }

    /**
     * @return the mail message's size
     * @since 6.0
     */
    public int getSize() {
        return size;
    }
}
