package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public class NoSuchLabelException extends NoSuchEntityException {

    private final String labelName;

    public NoSuchLabelException(@Nonnull KeyedMessage message, @Nonnull String labelName) {
        super(message);
        this.labelName = requireNonNull(labelName, "labelName");
    }

    @Nonnull
    public String getLabelName() {
        return labelName;
    }
}
