package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.validation.ArgumentValidationException;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public class LabelExistsException extends ArgumentValidationException {

    private final Label label;

    public LabelExistsException(@Nonnull KeyedMessage message, @Nonnull Label label) {
        super(message);
        this.label = requireNonNull(label, "label");
    }

    @Nonnull
    public Label getLabel() {
        return label;
    }
}