package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public abstract class AbstractLabelRequest {

    private final Labelable labelable;
    private final Label label;

    protected AbstractLabelRequest(@Nonnull AbstractBuilder<?, ?> builder) {
        labelable = requireNonNull(builder.labelable, "labelable");
        label = requireNonNull(builder.label, "label");
    }

    @Nonnull
    public Labelable getLabelable() {
        return labelable;
    }

    @Nonnull
    public Label getLabel() {
        return label;
    }

    public abstract static class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractLabelRequest>
            extends BuilderSupport {

        private Labelable labelable;
        private Label label;

        @Nonnull
        public abstract R build();

        @Nonnull
        public B labelable(@Nonnull Labelable value) {
            labelable = requireNonNull(value, "labelable");
            return self();
        }

        @Nonnull
        public B label(@Nonnull Label value) {
            label = requireNonNull(value, "label");
            return self();
        }

        @Nonnull
        protected abstract B self();
    }
}
