package com.atlassian.bitbucket.jira;

import java.net.URI;

/**
 * Encapsulates Jira interactions for:
 * <ol>
 *     <li>creating a reciprocated (2-way) Application Link;</li>
 *     <li>authenticating that link with Trusted Applications; and</li>
 *     <li>(optionally) creating a user directory from the selected Jira server.</li>
 * </ol>
 * This has been designed and tested with the setup process in mind, and makes the assumption that both the local
 * application and the remote Jira server have identical user bases and <strong>trust</strong>.
 */
public interface JiraSetupService {

    /**
     * Create an authenticated, reciprocated Application Link to a Jira server, and optionally set up a Jira user
     * directory for it.
     *
     * @param remoteRpcUrl RPC URL of the remote Jira application
     * @param localRpcUrl RPC URL of the local Jira application <em>that is resolvable by the remote Jira application</em>
     * @param username Jira administrator username
     * @param password password corresponding to the supplied username
     * @param setupUserManagement if true, create a local user directory backed by the remote Jira server
     *
     * @throws JiraSetupException if something goes wrong with link creation, authentication or Crowd delegation.
     * Clients should display the exception message to the user <strong>and log the exception</strong>.
     */
    void createLink(URI remoteRpcUrl, URI localRpcUrl, String username, String password,
                    boolean setupUserManagement) throws JiraSetupException;
}
