package com.atlassian.bitbucket.idx;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.Date;
import java.util.Set;

/**
 * Represents a commit that has been indexed.
 */
public interface IndexedCommit {

    /**
     * @return the timestamp when the commit was authored
     */
    @Nonnull
    Date getAuthorTimestamp();

    /**
     * @return the commit ID
     */
    @Nonnull
    String getId();

    /**
     * @return the repositories this commit has been indexed in, which may be empty but never {@code null}
     */
    @Nonnull
    Set<Repository> getRepositories();
}
