package com.atlassian.bitbucket.hook.script;

/**
 * A minimal representation of a {@link HookScript}, retaining only its ID and version.
 *
 * @since 6.2
 */
public interface MinimalHookScript {

    /**
     * Retrieves the script's <i>globally unique</i> ID.
     * <p>
     * When a hook script is created it is assigned an ID, which can be used to retrieve the script later in order
     * to update or delete it, or configure it to run in a given {@link com.atlassian.bitbucket.scope.Scope scope}.
     * <i>Apps are expected to track the IDs of the scripts they create</i> so they can manage them afterward.
     *
     * @return the script's ID
     */
    long getId();

    /**
     * Retrieves the script's version.
     * <p>
     * Each time a script's <i>contents</i> are updated, it receives a new version. Updating a script's
     * {@link HookScript#getDescription description}, {@link HookScript#getName name} or
     * {@link HookScript#getPluginKey plugin key} does <i>not</i> update its version.
     * <p>
     * If a script's contents are updated concurrently, one updater will succeed and the rest will fail. If a
     * script's metadata is updated concurrently, the last updater "wins" and other updates are overwritten.
     *
     * @return the version of the script
     */
    int getVersion();
}
