package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 6.2
 */
public class HookScriptRemoveConfigurationRequest {

    private final Scope scope;
    private final HookScript script;

    private HookScriptRemoveConfigurationRequest(Builder builder) {
        scope = builder.scope;
        script = builder.script;
    }

    @Nonnull
    public Scope getScope() {
        return scope;
    }

    @Nonnull
    public HookScript getScript() {
        return script;
    }

    public static class Builder {

        private final Scope scope;
        private final HookScript script;

        public Builder(@Nonnull HookScript script, @Nonnull Scope scope) {
            this.scope = requireNonNull(scope, "scope");
            this.script = requireNonNull(script, "script");
        }

        @Nonnull
        public HookScriptRemoveConfigurationRequest build() {
            return new HookScriptRemoveConfigurationRequest(this);
        }
    }
}
