package com.atlassian.bitbucket.hook.script;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event fired when a {@link HookScript} is deleted from the system.
 *
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 *
 * @since 6.2
 */
@AsynchronousPreferred
@EventName("stash.hook.script.deleted")
public class HookScriptDeletedEvent extends HookScriptEvent {

    public HookScriptDeletedEvent(@Nonnull Object source, @Nonnull HookScript hookScript) {
        super(source, hookScript);
    }
}
