package com.atlassian.bitbucket.hook.script;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event fired when a new {@link HookScript} is added to the system.
 *
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 *
 * @since 6.2
 */
@AsynchronousPreferred
@EventName("stash.hook.script.created")
public class HookScriptCreatedEvent extends HookScriptEvent {

    public HookScriptCreatedEvent(@Nonnull Object source, @Nonnull HookScript hookScript) {
        super(source, hookScript);
    }
}
