package com.atlassian.bitbucket.hook;

import javax.annotation.Nonnull;
import java.io.PrintWriter;
import java.util.Optional;

/**
 * Describes an SCM hook invocation, providing access to the output and error streams of the remote client
 *
 * @since 5.0
 */
public interface ScmHookDetails {

    /**
     * @return a {@link PrintWriter} that can be used to output error messages to the remote client.
     */
    @Nonnull
    PrintWriter err();

    /**
     * @return the hook-identifier provided by the SCM hook callback
     */
    @Nonnull
    Optional<String> getHookName();

    /**
     * @return a {@link PrintWriter} that can be used to output messages to the remote client.
     */
    @Nonnull
    PrintWriter out();
}
