package com.atlassian.bitbucket.event.server;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the application base url is changed.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
public class BaseUrlChangedEvent extends ApplicationConfigurationChangedEvent<String> {

    public BaseUrlChangedEvent(@Nonnull Object source, @Nullable String oldValue, @Nonnull String newValue) {
        super(source, Property.BASE_URL, oldValue, requireNonNull(newValue, "newValue"));
    }

    @Nonnull
    @Override
    @SuppressWarnings("ConstantConditions") //Null newValues are rejected by the constructor
    public String getNewValue() {
        return super.getNewValue();
    }
}
